(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4498,        157]*)
(*NotebookOutlinePosition[      5341,        184]*)
(*  CellTagsIndexPosition[      5297,        180]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \( (*\ Example\ 2.6  .2\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(p[1] = E - 1; \np[i_] := \ E - \((i - 1)\)*p[i - 1]; \n
    Table[p[i], {i, 2, 8}] // Simplify\)], "Input"],

Cell[BoxData[
    \({1, \(-2\) + E, 6 - 2\ E, \(-24\) + 9\ E, 120 - 44\ E, 
      5\ \((\(-144\) + 53\ E)\), 5040 - 1854\ E}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(el[1, 1] = NIntegrate[\((Exp[x] - 1)\)/x, \ {x, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(1.31790215145440336`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[\((Exp[x] - 1)\)/x, \ {x, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(\(-EulerGamma\) - I\ \[Pi] - 
      MeijerG[{{}, {1}}, {{0, 0}, {}}, \(-1\)]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(el[i_, 1] := \ p[i - 1] - 1/\((i - 1)\); \n
    Table[el[i, 1], {i, 2, 8}]\)], "Input"],

Cell[BoxData[
    \({\(-2\) + E, 1\/2, \(-\(7\/3\)\) + E, 
      \(-\(1\/4\)\) - 3\ \((\(-2\) + E)\) + E, 
      \(-\(1\/5\)\) + E - 4\ \((\(-3\)\ \((\(-2\) + E)\) + E)\), 
      \(-\(1\/6\)\) + E - 5\ \((E - 4\ \((\(-3\)\ \((\(-2\) + E)\) + E)\))\), 
      \(-\(1\/7\)\) + E - 
        6\ \((E - 5\ \((E - 4\ \((\(-3\)\ \((\(-2\) + E)\) + E)\))\))\)}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(el[i_, j_] := \ p[i - 1] - \((j - 1)\)*el[i - 1, j - 1]; \nel[2, 2]\)], 
  "Input"],

Cell[BoxData[
    \(0.40037967700464172`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(el[2, 3]\)], "Input"],

Cell[BoxData[
    \($RecursionLimit::"reclim" \( : \ \) 
      "Recursion depth of \!\(256\) exceeded."\)], "Message"],

Cell[BoxData[
    \($RecursionLimit::"reclim" \( : \ \) 
      "Recursion depth of \!\(256\) exceeded."\)], "Message"],

Cell[BoxData[
    \($RecursionLimit::"reclim" \( : \ \) 
      "Recursion depth of \!\(256\) exceeded."\)], "Message"],

Cell[BoxData[
    \(General::"stop" \( : \ \) 
      "Further output of \!\($RecursionLimit :: \"reclim\"\) will be \
suppressed during this calculation."\)], "Message"],

Cell[BoxData[
    \(\(-1\) - 2\ \((\(-1\) + E)\) + E\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(el[2, 4]\)], "Input"],

Cell[BoxData[
    \($RecursionLimit::"reclim" \( : \ \) 
      "Recursion depth of \!\(256\) exceeded."\)], "Message"],

Cell[BoxData[
    \($RecursionLimit::"reclim" \( : \ \) 
      "Recursion depth of \!\(256\) exceeded."\)], "Message"],

Cell[BoxData[
    \($RecursionLimit::"reclim" \( : \ \) 
      "Recursion depth of \!\(256\) exceeded."\)], "Message"],

Cell[BoxData[
    \(General::"stop" \( : \ \) 
      "Further output of \!\($RecursionLimit :: \"reclim\"\) will be \
suppressed during this calculation."\)], "Message"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{4, Automatic}, {Automatic, -2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 59, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[1801, 54, 127, 2, 59, "Input"],
Cell[1931, 58, 138, 2, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2106, 65, 87, 1, 27, "Input"],
Cell[2196, 68, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2287, 74, 75, 1, 27, "Input"],
Cell[2365, 77, 110, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2512, 84, 107, 2, 43, "Input"],
Cell[2622, 88, 368, 7, 110, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3027, 100, 103, 2, 43, "Input"],
Cell[3133, 104, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3224, 110, 41, 1, 27, "Input"],
Cell[3268, 113, 118, 2, 21, "Message"],
Cell[3389, 117, 118, 2, 22, "Message"],
Cell[3510, 121, 118, 2, 22, "Message"],
Cell[3631, 125, 169, 3, 52, "Message"],
Cell[3803, 130, 66, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3906, 136, 41, 1, 27, "Input"],
Cell[3950, 139, 118, 2, 22, "Message"],
Cell[4071, 143, 118, 2, 22, "Message"],
Cell[4192, 147, 118, 2, 22, "Message"],
Cell[4313, 151, 169, 3, 52, "Message"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

